#region Using statements
using System;
using System.Data;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.ComponentModel;
using System.Text.RegularExpressions;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Class DataGridAbs
	/// </summary>
	public class DataGridAbs : System.Windows.Forms.Panel
	{		
		#region Constants
		private const int MAXSCREENINGCELLS = 5;
		#endregion

		#region Events

		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;

		/// <summary>
		/// RowVersionChanged Event
		/// </summary>
		public event RowVersionChangedEventHandler RowVersionChanged;

		#endregion

		#region Variables
		private Hashtable resultLookup;
		private System.Data.DataTable _dtABS;
		private System.Windows.Forms.DataGridTableStyle _dgTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgABS;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.ComponentModel.IContainer components;
		private BOL.Division _division;
		private string _validEntries = string.Empty;
		private BOL.OrderedTest _orderedTest;
		private controls.ComboBoxLookup cmbBoxComment;
		private string _testingTech;
		private DateTime _testDate;
		private Common.ReactivityPhase _reactivityPhase;
		private char _testStatusCode;
		private bool _datExists;

		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;

		private System.Guid _parentFormGuid = System.Guid.Empty;
		private bool _keyPressEventHandled;

		#endregion

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		public DataGridAbs()
		{
			InitializeComponent();
			InitializeGrid();
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridAbs));
			this.dgABS = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.btnClear = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			((System.ComponentModel.ISupportInitialize)(this.dgABS)).BeginInit();
			this.SuspendLayout();
			// 
			// dgABS
			// 
			this.dgABS.AllowSorting = false;
			this.dgABS.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dgABS.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgABS.CaptionText = "Antibody Screen (ABS)";
			this.dgABS.CaptionVisible = false;
			this.dgABS.DataMember = string.Empty;
			this.dgABS.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgABS.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgABS.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgABS.Name = "dgABS";
			this.dgABS.RowHeadersVisible = false;
			this.dgABS.Size = new System.Drawing.Size(492, 96);
			this.dgABS.TabIndex = 43;
			this.dgABS.ToolTipColumn = -1;
			this.dgABS.CurrentCellChanged += new System.EventHandler(this.dgABS_CurrentCellChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnClear.Image = ((System.Drawing.Bitmap)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(470, 1);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 44;
			this.toolTip1.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearResults().ResString);
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// DataGridAbs
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnClear,
																		  this.dgABS});
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "DataGridAbs";
			this.Size = new System.Drawing.Size(492, 96);
			((System.ComponentModel.ISupportInitialize)(this.dgABS)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Guid of the control's container - needed for locking
		/// </summary>
		public System.Guid ParentFormGuid
		{
			get
			{
				if (this._parentFormGuid == System.Guid.Empty)
				{
					throw new BOL.BusinessObjectException("Locking Requirement missing -- ParentFormGuid not set.");
				}
				return(this._parentFormGuid);
			}
			set
			{
				this._parentFormGuid = value;
			}
		}

		#endregion

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// Get or set test date
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._dtABS.Rows[0].IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._dtABS.Rows[0][TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Set the value telling ABS grid that it comes with DAT
		/// </summary>
		public bool DATExists
		{
			get
			{
				return this._datExists;
			}

			set
			{
				this._datExists = value;
			}
		}

		/// <summary>
		/// Update row version when the part of the order (TAS or ABS) has been invalidated
		/// </summary>
		public byte[] RowVersionOrderedTest
		{
			set
			{
				this._dtABS.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = value;
				this.OrderedTest.RowVersion = value;
				if (this.IsGridPartiallyCompleted() == false)
				{
					foreach(DataRow dr in this._dtABS.Rows)
					{
						dr[ARTIFICIAL.ISGuid] = DBNull.Value;
						dr[ARTIFICIAL.C37Guid] = DBNull.Value;
						dr[ARTIFICIAL.AHGGuid] = DBNull.Value;
						dr[ARTIFICIAL.CCGuid] = DBNull.Value;
						dr[ARTIFICIAL.ABSInterpGuid] = DBNull.Value;
						dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
						dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
						dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
						dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
						dr[ARTIFICIAL.ABSInterpRowVersion] = DBNull.Value;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		public void InitializeGrid()
		{
			this.cmbBoxComment = new controls.ComboBoxLookup();
			this.cmbBoxComment.MaxLength = 255;
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.TabIndex = 0;
			this.cmbBoxComment.Width = 115;
			this.cmbBoxComment.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBoxComment_Validating);
			this.cmbBoxComment.LookupEnabled = false;

			this.dgABS.CaptionVisible = true;
			this.dgABS.Enter += new System.EventHandler(dgABS_Enter);
			this.dgABS.Leave += new EventHandler(dgABS_Leave);
			this.dgABS.LostFocus +=new EventHandler(dgABS_LostFocus);
			this.dgABS.SizeChanged += new EventHandler(dgABS_SizeChanged);
			this.dgABS.NextCell += new controls.NextCellEventHandler(SetNextCell);
			//
			InitializeLookup();
			_dtABS = new DataTable();
			this.dgABS.DataSource = _dtABS.DefaultView;
			this.GridDataSource = this._dtABS;
			this.cmbBoxComment.SelectedIndex = -1;
			((DataView)dgABS.DataSource).AllowNew = false;
			((DataView)dgABS.DataSource).AllowDelete = false;
			this._keyPressEventHandled = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add(string.Empty, string.Empty);
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// BR_53.04
		/// </summary>
		public void CreateAbsTable(BOL.OrderedTest test, bool isAutoControl, Guid rackGuid)
		{
			bool absResultsExist = false;
			//Set data table name - very important
			_dtABS = new System.Data.DataTable("ABS");
			this._orderedTest = test;

			//Header information
			_dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.ScreeningCells,typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
			_dtABS.Columns.Add(ARTIFICIAL.ABSInterp, typeof(String));			
			_dtABS.Columns.Add(ARTIFICIAL.ABSComment, typeof(String));
			_dtABS.Columns.Add(TABLE.ValidRhResult.SystemInterp, typeof(String));
			_dtABS.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			_dtABS.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			_dtABS.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			_dtABS.Columns.Add(TABLE.OrderableTest.OrderableTestId);
			_dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.ABSInterpSave, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			_dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			_dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			_dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			_dtABS.Columns.Add(ARTIFICIAL.ABSInterpGuid, typeof(Guid));			
			_dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			_dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			_dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			_dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			_dtABS.Columns.Add(ARTIFICIAL.ABSInterpRowVersion, typeof(byte[]));			
			_dtABS.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			_dtABS.Columns.Add(ARTIFICIAL.NonStandardTestException, typeof(BOL.ExceptionReport));
			_dtABS.Columns.Add(ARTIFICIAL.NonStandardTestExceptionIndicator, typeof(bool));
			_dtABS.Columns.Add(ARTIFICIAL.EmergencyIssueExceptions, typeof(ArrayList));
			_dtABS.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			_dtABS.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			//CR 2080 Added CPRSOrderNumber to ABS data table to allow completion of the ABS 
				//orders (CPRS order number is required by the procedure that sends message to Vista)
			_dtABS.Columns.Add(TABLE.OrderedTest.CprsOrderNumber);

			//this columns should always be the last columns of the grid
			//when adding new columns please make sure that they are added before ARTIFICIAL.IndicatorMessage
			_dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			//Set grid style
			if (_dgTableStyle == null)
			{
				AddCustomDataTableStyle();
			}

			//veryfing if there are any ABS results in the database
			//if not than treat this test as not started (for TAS and ABS+DAT only)
			DataTable dtSpecimenTests = BOL.OrderedTest.GetTestResultsForTask(test.OrderedTestGuid);
			if (dtSpecimenTests.Select(TABLE.BloodTestType.BloodTestName + " LIKE '*Screen*' OR " + TABLE.BloodTestType.BloodTestName + " LIKE '*Auto Control*'").Length > 0)
			{
				absResultsExist = true;
				int reactivityPhase = Convert.ToInt32(dtSpecimenTests.Select(TABLE.BloodTestType.BloodTestName + " LIKE '*Screen*' OR " + TABLE.BloodTestType.BloodTestName + " LIKE '*Auto Control*'")[0][TABLE.SpecimenTest.ReactivityPhaseCode].ToString());
				if (reactivityPhase == (int)Common.ReactivityPhase.IAT)
					this._reactivityPhase = Common.ReactivityPhase.IAT;
				else
					this._reactivityPhase = Common.ReactivityPhase.All;
			}
		
			if ((absResultsExist == true &&
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected)) ||
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				this._testStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted);
			}

			if (this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) &&
				absResultsExist == true)
			{
				//CRT - 101405 - We need to cater for Transfusion-Only sites here too!
				if (this._division.ServiceTypeIndicator)
				{
					for (int i = 0; i < 4; i++)
					{
						string vialID = (i+1).ToString();
						AddRow(test, "SC" + vialID, i, rackGuid, absResultsExist);
					}
					AddRow(test, "Auto", MAXSCREENINGCELLS, rackGuid, absResultsExist);
				}
				else
				{
					AddRow(test, "SC", 0, rackGuid, absResultsExist);
				}
			}
			else
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					//Fill in grid rows with applicable daily QC reagent types
					DataTable dtReagentList = BOL.ReagentType.GetDailyQCReagentTypes(this.DivisionCode);
					try
					{
						DataRow[] drScreenCells = dtReagentList.Select(TABLE.ReagentType.ReagentTypeId + " = 63", ARTIFICIAL.SetVialId);
						for (int i = 0; i <drScreenCells.Length; i++)
						{
							string vialID = drScreenCells[i][ARTIFICIAL.SetVialId].ToString();
							AddRow(test, "SC" + vialID, i, rackGuid, absResultsExist);
						}
					}
					catch (IndexOutOfRangeException) 
					{
						//No more screening cells in list.  Do nothing with error.
					}
			 
					//If there is an autocontrol row, add it in
					if (isAutoControl)
					{
						AddRow(test, "Auto", MAXSCREENINGCELLS, rackGuid, absResultsExist);
					}
				}
				else
				{
					AddRow(test, "SC", 0, rackGuid, absResultsExist);
				}
			}

			//Set data source
			if (this._dtABS.Rows.Count == 0)
			{
				this.dgABS.DataSource = this._dtABS.DefaultView;
				this.dgABS.ColumnHeadersVisible = false;
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}
			else
			{
				this.dgABS.DataSource = this._dtABS.DefaultView;
				((DataView)dgABS.DataSource).AllowNew = false;
				((DataView)dgABS.DataSource).AllowDelete = false;
				this.dgABS.ColumnHeadersVisible = true;
				this.btnClear.Enabled = true;
				enableInvalidation = true;
				this.cmbBoxComment.SelectedIndex = -1;
			}

			if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
			{
				for (int i=0; i<this._dtABS.Rows.Count; i++)
				{
					UpdateSolidGelIndicator();
				}
			}
			else
			{
				for (int i=0; i<this._dtABS.Rows.Count; i++)
				{
					UpdateTubeIndicator();
				}
			}

			this.dgABS.ToolTipColumn = _dtABS.Columns.Count - 1;
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		/// <summary>
		/// Adds a row to the grid
		/// </summary>
		/// <param name="Test"></param>
		/// <param name="colTitle"></param>
		/// <param name="rowNumber"></param>
		/// <param name="rackGuid"></param>
		/// <param name="absResultsExist"></param>
		private void AddRow(BOL.OrderedTest Test, string colTitle, int rowNumber, Guid rackGuid, bool absResultsExist)
		{
			DataRow dr = _dtABS.NewRow();

			//Sets row information			
			dr[TABLE.Patient.PatientGuid] = Test.Patient.PatientGuid;
			dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = Test.Specimen.SpecimenGuid;
			dr[TABLE.OrderedTest.OrderedTestGuid] = Test.OrderedTestGuid;
			dr[TABLE.OrderableTest.OrderableTestId] = Test.OrderableTestId;
			dr[ARTIFICIAL.OrderedTestRowVersion] = Test.RowVersion;
			dr[ARTIFICIAL.Indicator] = string.Empty;
		
 			if (this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) &&
				absResultsExist == true)
			{
				dr[ARTIFICIAL.ScreeningCells] = colTitle;
				dr[ARTIFICIAL.IS] = null;
				dr[ARTIFICIAL.C37] = null;
				dr[ARTIFICIAL.AHG] = null;
				dr[ARTIFICIAL.CC] = null;
				dr[ARTIFICIAL.ISSave] = false;
				dr[ARTIFICIAL.C37Save] = false;
				dr[ARTIFICIAL.AHGSave] = false;
				dr[ARTIFICIAL.CCSave] = false;		
			}
			else
			{
				if (this._division.ServiceTypeIndicator == true)	//Full-service
				{
					dr[ARTIFICIAL.ScreeningCells] = colTitle;
					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						dr[ARTIFICIAL.IS] = null;
						dr[ARTIFICIAL.C37] = null;
						dr[ARTIFICIAL.CC] = null;
						dr[ARTIFICIAL.ISSave] = false;
						dr[ARTIFICIAL.C37Save] = false;
						dr[ARTIFICIAL.CCSave] = false;		
					}
					else
					{
						dr[ARTIFICIAL.IS] = string.Empty;
						dr[ARTIFICIAL.C37] = string.Empty;
						dr[ARTIFICIAL.CC] = string.Empty;
						dr[ARTIFICIAL.ISSave] = true;
						dr[ARTIFICIAL.C37Save] = true;
						dr[ARTIFICIAL.CCSave] = true;		
					}
					dr[ARTIFICIAL.AHG] = string.Empty;
					dr[ARTIFICIAL.AHGSave] = true;
				}
				else	//Transfusion only
				{
					dr[ARTIFICIAL.ScreeningCells] = null;
					dr[ARTIFICIAL.IS] = null;
					dr[ARTIFICIAL.C37] = null;
					dr[ARTIFICIAL.AHG] = null;
					dr[ARTIFICIAL.CC] = null;
					dr[ARTIFICIAL.ISSave] = false;
					dr[ARTIFICIAL.C37Save] = false;
					dr[ARTIFICIAL.AHGSave] = false;
					dr[ARTIFICIAL.CCSave] = false;		
				}
			}
			
			if (rowNumber == 0)
			{
				//Makes 1st row usable
				dr[ARTIFICIAL.ABSInterp] = string.Empty;
				dr[ARTIFICIAL.ABSComment] = string.Empty;
			}
			else
			{
				//Grays out all other rows
				dr[ARTIFICIAL.ABSInterp] = null;
				dr[ARTIFICIAL.ABSComment] = null;
			}

			//dr[ARTIFICIAL.ABSComment] = string.Empty;
			dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
			dr[ARTIFICIAL.ABSInterpSave] = true;
			dr[ARTIFICIAL.PartiallyCompleted] = true;
				
			if (rackGuid != Guid.Empty)
				dr[TABLE.Rack.RackGuid] = rackGuid;

			if (this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
			else
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = false;

			dr[TABLE.OrderedTest.CprsOrderNumber] = Test.CPRSOrderNumber;
			_dtABS.Rows.Add(dr);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddCustomDataTableStyle()
		{
			_dgTableStyle = new DataGridTableStyle();
			_dgTableStyle.PreferredRowHeight = 22;
			dgABS.TableStyles.Add(_dgTableStyle);
			_dgTableStyle.AllowSorting = false;
			_dgTableStyle.DataGrid = dgABS;

			_dgTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgTableStyle.MappingName = "ABS";
			_dgTableStyle.RowHeadersVisible = false;

			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// ScreeningCell
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.HeaderText = "SC";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ScreeningCells;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 35;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// IS
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// 37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// AHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// ABSInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "ABS Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ABSInterp;
			_dcTextKeyTrapCol.Width = 65;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// ABSComment
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.HeaderText = "ABS Comment";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ABSComment;
			_dcTextKeyTrapCol.Width = 120;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.Controls.Add(cmbBoxComment);
			cmbBoxComment.BringToFront();
			cmbBoxComment.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// dcSystemInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ValidRhResult.SystemInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedTestGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Save
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Save;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcABSInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ABSInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Guid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcABSInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ABSInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37RowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcABSInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ABSInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcNonStandardTestException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.NonStandardTestException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcNonStandardTestExceptionIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.NonStandardTestExceptionIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcEmergencyIssueExceptions
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.EmergencyIssueExceptions;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCPRSOrderNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.CprsOrderNumber;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
		}



		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgABS.CurrentCell.RowNumber;
			int col = this.dgABS.CurrentCell.ColumnNumber;

			if (row == this._dtABS.Rows.Count - 1)
			{
				if (col < 7 && col > 1)
				{
					this.dgABS.SetCurrentCell(0, col+1);
				}
				else if (col == 7)
				{
					this.dgABS.SetCurrentCell(0, 0);
				}
			}
			else
			{
				this.dgABS.SetCurrentCell(row + 1, col);
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Updates the datagrid indicator to indicate the status of tube test results
		/// BR_56.29, BR_53.02, TT_53.01, TT_53.02
		/// </summary>
		private void UpdateTubeIndicator()
		{
			string Interp = this._dtABS.Rows[0][ARTIFICIAL.ABSInterp].ToString();
			bool showOverrideMsgs = true;
			string exceptionPhases = string.Empty;
			//string systemInterp;
			if (this._dtABS.Rows[0][ARTIFICIAL.ABSInterp].ToString().Trim() != string.Empty &&
				(bool)this._dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] == false)
			{
				this.btnClear.Enabled = false;
				enableInvalidation = false;
				showOverrideMsgs = false;
			}
			
			for (int row = 0; row < this._dtABS.Rows.Count; row++)
			{
				DataRow drUpdate = this._dtABS.Rows[row];

				//if (this._division.ServiceTypeIndicator == true ||
				//(this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				//CRT - 101405 - The Partially Completed check will allow Transfusion-Only sites to enter here when returning from save
				if (this._division.ServiceTypeIndicator == true)
				{
						string ISResult = resultLookup[drUpdate[ARTIFICIAL.IS].ToString()].ToString();
						string ThirtySevenResult = resultLookup[drUpdate[ARTIFICIAL.C37].ToString()].ToString();
						string AHGResult = resultLookup[drUpdate[ARTIFICIAL.AHG].ToString()].ToString();
						string CCResult = resultLookup[drUpdate[ARTIFICIAL.CC].ToString()].ToString();

						//No interpretation made.  Exit.
					if (Interp == string.Empty && (ISResult == string.Empty || ThirtySevenResult == string.Empty || AHGResult == string.Empty || CCResult == string.Empty))
					{
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
					}
					else if (ISResult == "X" && ThirtySevenResult == "X" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "N";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "N" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "N";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "P" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "N")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "N" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "P" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "N" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "N";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "P" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "N" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "P" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "X" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "X" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "N";
						drUpdate[ARTIFICIAL.Indicator] = "W";
						drUpdate[ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = true;
						exceptionPhases = ARTIFICIAL.C37;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "N" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "W";
						drUpdate[ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = true;
						exceptionPhases = "37/CC";
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "W";
						drUpdate[ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = true;
						exceptionPhases = ARTIFICIAL.C37;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "X" &&  AHGResult == "N" && CCResult == "P")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "W";
						drUpdate[ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = true;
						exceptionPhases = ARTIFICIAL.C37;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else if (ISResult == "P" && ThirtySevenResult == "X" &&  AHGResult == "P" && CCResult == "X")
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						drUpdate[ARTIFICIAL.Indicator] = "W";
						drUpdate[ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = true;
						exceptionPhases = "37/CC";
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else
					{
						drUpdate[TABLE.ValidRhResult.SystemInterp] = string.Empty;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.Indicator] = "E";
							drUpdate[ARTIFICIAL.IndicatorMessage] = "You are attempting to file an invalid reaction combination.";
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
							drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						}
					}
				}
				else //Transfusion-Only facility
				{
					if (drUpdate[ARTIFICIAL.ABSInterp].ToString().Trim() != string.Empty)
					{
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
						//CRT- 101405 - We need to update the system interp to match, or it'll change back to 'E'
						drUpdate[TABLE.ValidRhResult.SystemInterp] = drUpdate[ARTIFICIAL.ABSInterp];
					}
					else
					{
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
			}

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				if (Interp != string.Empty)
				{
					int valid = 0;
					int warning = 0;
					int invalid = 0;

					for (int row = 0; row < this._dtABS.Rows.Count; row++)
					{
						if (this._dtABS.Rows[row][ARTIFICIAL.Indicator].ToString() == "E")
						{
							invalid++;
						}
						else
						{
							valid++;
						}

						if (this._dtABS.Rows[row].IsNull(ARTIFICIAL.NonStandardTestExceptionIndicator) == false)
						{
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.NonStandardTestExceptionIndicator] == true)
							{
								warning++;
							}
						}
					}

					string systemInterp = "N";

					if (invalid > 0)
					{
						for (int row = 0; row < this._dtABS.Rows.Count; row++)
						{
							this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "E";
							this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = "You are attempting to file an invalid reaction combination.";
							this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else
					{
						for (int row = 0; row < this._dtABS.Rows.Count; row++)
						{
							if (this._dtABS.Rows[row][TABLE.ValidRhResult.SystemInterp].ToString().Trim() == "P")
							{
								systemInterp = "P";
								break;
							}
							else if (this._dtABS.Rows[row][TABLE.ValidRhResult.SystemInterp].ToString().Trim() == string.Empty)
							{
								systemInterp = string.Empty;
								break;
							}
						}

						if (systemInterp != Interp)
						{
							for (int row = 0; row < this._dtABS.Rows.Count; row++)
							{
								this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "E";
								this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = "Interpretation does not match entries. Please correct";
								this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = true;
							}
						}
						else
						{
							if (warning > 0 &&
								this._dtABS.Rows[0].IsNull(ARTIFICIAL.NonStandardTestException) &&
								showOverrideMsgs == true)
							{
								DlgOverrideComment dlg = new DlgOverrideComment("Non-standard test procedure", "Non-standard test procedure", "PT");

                                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(parentForm, false);

								if (dlg.DialogResult == DialogResult.OK)
								{
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Non_standard_test_procedure, dlg.Comment, Common.LogonUser.LogonUserName);
						
									exRep.GenerateExceptionPatientTest(this._orderedTest, exceptionPhases, Interp, this._testDate, this._testingTech);
									this._dtABS.Rows[0][ARTIFICIAL.NonStandardTestException] = exRep;

								}
								else
								{
									this._dtABS.Rows[0][ARTIFICIAL.ABSInterp] = string.Empty;
									this._dtABS.Rows[0][ARTIFICIAL.NonStandardTestException] = DBNull.Value;
								}
							}
							else if (warning == 0)
							{
								this._dtABS.Rows[0][ARTIFICIAL.NonStandardTestException] = DBNull.Value;
							}

							if (this._dtABS.Rows[0].IsNull(ARTIFICIAL.NonStandardTestException) == false)
							{
								for (int row = 0; row < this._dtABS.Rows.Count; row++)
								{
									this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "W";
									this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = "Non-standard test procedure";
									this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = false;
								}
							}
							else
							{
								for (int row = 0; row < this._dtABS.Rows.Count; row++)
								{
									this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "V";
									this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = string.Empty;
									this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = false;
								}
							}
						}
					}
				}
			}

			if (Interp != string.Empty)
			{
				//BR_56.29
				if (Interp == "P")
				{
					if (this._dtABS.Rows[0].IsNull(ARTIFICIAL.EmergencyIssueExceptions) &&
						showOverrideMsgs == true)
					{
						DataTable dtIssuedUnits = BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest(this._orderedTest.OrderedTestGuid);
						if (dtIssuedUnits.Rows.Count > 0)
						{
							DlgOverrideComment dlg = new DlgOverrideComment( "Positive ABS Result", Common.StrRes.SysErrMsg.UC056.EmergencyUnitsIssued().ResString, "PT" );

                            dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(parentForm, false);

							if( dlg.DialogResult == DialogResult.Cancel )
							{
								this._dtABS.Rows[0][ARTIFICIAL.ABSInterp] = string.Empty;
								Interp = string.Empty;
								this.dgABS.SetCurrentCell(0, 6);
								return;
							}
							else
							{
								ArrayList emergencyIssueExceptions = new ArrayList();
								foreach(DataRow drIssuedUnit in dtIssuedUnits.Rows)
								{
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_ER_issued_testing_problem, dlg.Comment, Common.LogonUser.LogonUserName);
									exRep.GenerateExceptionEmergencyIssueUnitTest((Guid)drIssuedUnit[TABLE.OrderedUnit.BloodUnitGuid], (Guid)this._dtABS.Rows[0][TABLE.Patient.PatientGuid], "ABS", "Pos", this.TestingTech);
									emergencyIssueExceptions.Add(exRep);
								}
								this._dtABS.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = emergencyIssueExceptions;
							}
						}
					}
				}
				else
				{
					this._dtABS.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = DBNull.Value;
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// BR_56.29, BR_53.02, TT_53.01, TT_53.02
		/// </summary>
		private void UpdateSolidGelIndicator()
		{
			string Interp = this._dtABS.Rows[0][ARTIFICIAL.ABSInterp].ToString();
			bool showOverrideMsgs = true;

			if (this._dtABS.Rows[0][ARTIFICIAL.ABSInterp].ToString().Trim() != string.Empty &&
				(bool)this._dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] == false)
			{
				this.btnClear.Enabled = false;
				enableInvalidation = false;
				showOverrideMsgs = false;
			}

			for (int row = 0; row < this._dtABS.Rows.Count; row++)
			{
				DataRow drUpdate = this._dtABS.Rows[row];

				string AHGResult = resultLookup[drUpdate[ARTIFICIAL.AHG].ToString()].ToString();

				switch (AHGResult)
				{
					case "":
						//No results entered.  Exit.
						drUpdate[TABLE.ValidRhResult.SystemInterp] = string.Empty;
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
						break;
					case "P": case "N":
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
						if (AHGResult == "P")
							drUpdate[TABLE.ValidRhResult.SystemInterp] = "P";
						else
							drUpdate[TABLE.ValidRhResult.SystemInterp] = "N";
						break;

					case "X":
						drUpdate[TABLE.ValidRhResult.SystemInterp] = string.Empty;
						if (Interp == string.Empty)
						{
							drUpdate[ARTIFICIAL.Indicator] = "E";
							drUpdate[ARTIFICIAL.IndicatorMessage] = "You are attempting to file an invalid reaction combination.";
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
							drUpdate[ARTIFICIAL.NonStandardTestExceptionIndicator] = false;
						}
						break;
				}
			}

			if (Interp != string.Empty)
			{
				int valid = 0;
				int invalid = 0;

				for (int row = 0; row < this._dtABS.Rows.Count; row++)
				{
					if (this._dtABS.Rows[row][ARTIFICIAL.Indicator].ToString() == "E")
					{
						invalid++;
					}
					else
					{
						valid++;
					}
				}

				string systemInterp = "N";

				if (invalid > 0)
				{
					for (int row = 0; row < this._dtABS.Rows.Count; row++)
					{
						this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "E";
						this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = "You are attempting to file an invalid reaction combination.";
						this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
				else
				{
					for (int row = 0; row < this._dtABS.Rows.Count; row++)
					{
						if (this._dtABS.Rows[row][TABLE.ValidRhResult.SystemInterp].ToString().Trim() == "P")
						{
							systemInterp = "P";
							break;
						}
						else if (this._dtABS.Rows[row][TABLE.ValidRhResult.SystemInterp].ToString().Trim() == string.Empty)
						{
							systemInterp = string.Empty;
							break;
						}
					}

					if (systemInterp != Interp)
					{
						for (int row = 0; row < this._dtABS.Rows.Count; row++)
						{
							this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "E";
							this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = "Interpretation does not match entries. Please correct";
							this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = true;
						}
					}
					else
					{
						for (int row = 0; row < this._dtABS.Rows.Count; row++)
						{
							this._dtABS.Rows[row][ARTIFICIAL.Indicator] = "V";
							this._dtABS.Rows[row][ARTIFICIAL.IndicatorMessage] = string.Empty;
							this._dtABS.Rows[row][ARTIFICIAL.PartiallyCompleted] = false;
						}
					}
				}
			}
			
			//BR_56.29
			if (Interp == "P")
			{
				if (this._dtABS.Rows[0].IsNull(ARTIFICIAL.EmergencyIssueExceptions) &&
					showOverrideMsgs == true)
				{
					DataTable dtIssuedUnits = BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest(this._orderedTest.OrderedTestGuid);
					if (dtIssuedUnits.Rows.Count > 0)
					{
						DlgOverrideComment dlg = new DlgOverrideComment( "Positive ABS Result", Common.StrRes.SysErrMsg.UC056.EmergencyUnitsIssued().ResString, "PT" );

                        dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                        VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                        dlg.ShowDialogFromLockedParent(parentForm, false);

						if( dlg.DialogResult == DialogResult.Cancel )
						{
							this._dtABS.Rows[0][ARTIFICIAL.ABSInterp] = string.Empty;
							Interp = string.Empty;
						}
						else
						{
							ArrayList emergencyIssueExceptions = new ArrayList();
							foreach(DataRow drIssuedUnit in dtIssuedUnits.Rows)
							{
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_ER_issued_testing_problem, dlg.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionEmergencyIssueUnitTest((Guid)drIssuedUnit[TABLE.OrderedUnit.BloodUnitGuid], (Guid)this._dtABS.Rows[0][TABLE.Patient.PatientGuid], "ABS", "Pos", this.TestingTech);
								emergencyIssueExceptions.Add(exRep);
							}
							this._dtABS.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = emergencyIssueExceptions;
						}
					}
				}
			}
			else
			{
				this._dtABS.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = DBNull.Value;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		/// <summary>
		/// Sets text for legend
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then get correct valid entry text
			switch (column)
			{
				case 2: case 3: case 4:	case 5://IS, 37, AHG, CC
					_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, R = Rouleaux, M = Microscopic, X = Not Tested";
					break;
				case 6:
					_validEntries = "P = Positive, N = Negative"; //Interp
					break;
				case 7:
					_validEntries = "Any Text";//Comment
					break;
				default:
					_validEntries = "Read-Only";
					break;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Checks if the Antibody Screen is valid
		/// </summary>
		/// <param name="systemInterp"></param>
		/// <param name="techInterp"></param>
		/// <param name="warning"></param>
		/// <param name="drUpdate"></param>
		private void CheckInvalidAntibodyScreen(string systemInterp, string techInterp, bool warning, DataRow drUpdate)
		{
			drUpdate[TABLE.ValidRhResult.SystemInterp] = systemInterp;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Events
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgABS.CurrentCell.RowNumber;
				int column = this.dgABS.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if (!char.IsLetterOrDigit(e.KeyChar))
				{
					if (column == 6 && e.KeyChar == System.Convert.ToChar(Keys.Enter))
					{
						SetNextCell();
					}

					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}

				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression
				if (column == 2 || column == 3 || column == 4)  //IS, 37, AHG
				{
					regPattern = @"(\A[HWFM1234R0X]\z)";
				}

				else if (column == 5)			//CC
				{
					regPattern = @"(\A[HWFM1234R0X]\z)";
				}

				else if (column == 6)			//Interp
				{
					regPattern = @"(\A[PN]\z)";
				}

				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening
					this._keyPressEventHandled = true;
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dt = ((DataView)this.dgABS.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					SetNextCell();
					this._keyPressEventHandled = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
			
				e.Handled = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgABS.GridEntered == true)
			{
				this.dgABS.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgABS.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgABS.CurrentCell.RowNumber;
				int column = this.dgABS.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgABS.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 2 || column == 3 || column == 4)  //IS, 37, AHG
						{
							regPattern = @"(\A[HWFM1234R0X]\z)";
						}

						else if (column == 5)			//CC
						{
							regPattern = @"(\A[HWFM1234R0X]\z)";
						}

						else if (column == 6)			//Interp
						{
							regPattern = @"(\A[PN]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
							{
								for (int i=0; i<this._dtABS.Rows.Count; i++)
								{
									UpdateSolidGelIndicator();
								}
							}
							else
							{
								for (int i=0; i<this._dtABS.Rows.Count; i++)
								{
									UpdateTubeIndicator();
								}
							}
							this.dgABS.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
					//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
						{
							for (int i=0; i<this._dtABS.Rows.Count; i++)
							{
								UpdateSolidGelIndicator();
							}
						}
						else
						{
							for (int i=0; i<this._dtABS.Rows.Count; i++)
							{
								UpdateTubeIndicator();
							}
						}
						this.dgABS.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgABS, e);

			this.OnUserActivity();
		}

		/// <summary>
		/// Invoke row changed event
		/// </summary>
		/// <param name="rowVersion"></param>
		protected virtual void OnRowVersionChanged(byte[] rowVersion)
		{
			if (RowVersionChanged != null)
				RowVersionChanged(this, EventArgs.Empty, rowVersion);
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgABS_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				bool fullGrid = true;
				int row = this.dgABS.CurrentCell.RowNumber;
				int col = this.dgABS.CurrentCell.ColumnNumber;

				foreach (DataRow drABS in this._dtABS.Rows)
				{
					if ((bool)drABS[ARTIFICIAL.ISSave] == true ||
						(bool)drABS[ARTIFICIAL.C37Save] == true ||
						(bool)drABS[ARTIFICIAL.AHGSave] == true ||
						(bool)drABS[ARTIFICIAL.CCSave] == true ||
						(bool)_dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] == true)
					{
						fullGrid = false;
					}
				}

				if (fullGrid == true)
				{
					this.dgABS.Enabled = false;
					return;
				}

				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						if (col < 4)
						{
							this.dgABS.SetCurrentCell(row, 4);
						}
						else if (col == 5)
						{
							this.dgABS.SetCurrentCell(row, 6);
						}
					}
					else
					{
						if (col < 2)
							this.dgABS.SetCurrentCell(row, col + 1);
					}

					switch(col)
					{
						case 2:
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.ISSave] == false)
								this.dgABS.SetCurrentCell(row, col + 1);
							break;
						case 3:
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.C37Save] == false)
								this.dgABS.SetCurrentCell(row, col + 1);
							break;
						case 4:
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.AHGSave] == false)
								this.dgABS.SetCurrentCell(row, col + 1);
							break;
						case 5:
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.CCSave] == false)
								this.dgABS.SetCurrentCell(row, col + 1);
							break;
						case 6:
							if (row == 0)
							{
								if ((bool)this._dtABS.Rows[row][ARTIFICIAL.ABSInterpSave] == false)
									this.dgABS.SetCurrentCell(row, col + 1);
							}
							else
							{
								this.dgABS.SetCurrentCell(0, col+1);
							}
							break;
						case 7:
							if (row > 0)
							{
								this.dgABS.SetCurrentCell(0, col);
							}
							else
							{
								if ((bool)this._dtABS.Rows[row][ARTIFICIAL.ABSInterpSave] == false)
								{
									this.dgABS.SetCurrentCell(row, col + 1);
								}
								else
								{
									if (this.cmbBoxComment.Items.Count == 0)
									{
										DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
										foreach (DataRow drComment in dtCannedComments.Rows)
										{
											this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
										}
									}
									this.cmbBoxComment.LookupEnabled = false;
									this.cmbBoxComment.Text = this._dtABS.Rows[row][ARTIFICIAL.ABSComment].ToString();
									this.cmbBoxComment.Show();
									this.cmbBoxComment.Focus();
								}
							}
							break;
					}
				}
				else //Transfusion-Only
				{
					if (col < 6)
					{
						this.dgABS.SetCurrentCell(row, 6);
					}

					if (col == 7)
					{
						if (row > 0)
						{
							this.dgABS.SetCurrentCell(0, col);
						}
						else
						{
							if ((bool)this._dtABS.Rows[row][ARTIFICIAL.ABSInterpSave] == false)
							{
								this.dgABS.SetCurrentCell(row, col + 1);
							}
							else
							{
								if (this.cmbBoxComment.Items.Count == 0)
								{
									DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
									foreach (DataRow drComment in dtCannedComments.Rows)
									{
										this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
									}
								}
								this.cmbBoxComment.LookupEnabled = false;
								this.cmbBoxComment.Text = this._dtABS.Rows[row][ARTIFICIAL.ABSComment].ToString();
								this.cmbBoxComment.Show();
								this.cmbBoxComment.Focus();
							}
						}
					}
				}

				for (int i=0; i<this._dtABS.Rows.Count; i++)
				{
					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						UpdateSolidGelIndicator();
					}
					else
					{
						UpdateTubeIndicator();
					}
				}

				SetValidEntries(col);
				OnCellChanged(EventArgs.Empty);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABS_Enter(object sender, System.EventArgs e)
		{
			try
			{
				this.dgABS.SetCurrentCell(0, 2);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABS_Leave(object sender, System.EventArgs e)
		{
			try
			{
				for (int i=0; i<this._dtABS.Rows.Count; i++)
				{
					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						UpdateSolidGelIndicator();
					}
					else
					{
						UpdateTubeIndicator();
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABS_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						this.SelectNextControl(this.dgABS,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABS_SizeChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.dgABS.TableStyles.Count>0)
				{
					DataGridTableStyle tblStyle = this.dgABS.TableStyles["ABS"];
					//
				    if (tblStyle != null)
				    {
				        tblStyle.GridColumnStyles[ARTIFICIAL.ABSComment].Width = this.dgABS.Width -
				                                                                 (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.ScreeningCells].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.IS].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.C37].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.AHG].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.CC].Width +
				                                                                  tblStyle.GridColumnStyles[ARTIFICIAL.ABSInterp].Width + 7);
				        this.cmbBoxComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.ABSComment].Width;
				    }
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Clears the test results and restores the grid to the initial state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			ClearGrid();
		}

		/// <summary>
		/// Clears the grid. This method is public because it is being invoked by context menu from main form of the UC_56
		/// </summary>
		public void ClearGrid()
		{
			if (this.IsGridEmpty() == true)
				return;

			if (this.IsGridPartiallyCompleted() == true)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult == DialogResult.OK)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionPatientTestInactivated(this._orderedTest, this._testingTech);
					
					if (this._orderedTest.OrderableTestId != (int)Common.OrderableTest.TAS)
					{
						if (this._division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyDAT)
						{
							this._orderedTest.InactivateTestResultsForOrderableTest(exRep, (int)Common.OrderableTest.ABS, Common.UpdateFunction.DataGridAbsClearGrid);
						}
						else
						{
							this._orderedTest.InactivateTestResults(exRep, Common.UpdateFunction.DataGridAbsClearGrid);
						}
					}
					else
					{
						this._orderedTest.InactivateTestResultsForOrderableTest(exRep, (int)Common.OrderableTest.ABS, Common.UpdateFunction.DataGridAbsClearGrid);
					}
					this.ClearTestResults(true);
				}
				else
					return;
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
				{
					this.ClearTestResults(false);
				}
				else
					return;
			}
			this._dtABS.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;
			if (this._orderedTest.OrderableTestId == (int)Common.OrderableTest.TAS ||
				this._datExists == true)
			{
				OnRowVersionChanged(this._orderedTest.RowVersion);
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
		private void ClearTestResults(bool clearAll)
		{
			if (this._dtABS.Rows.Count > 0)
			{
				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					foreach(DataRow drABS in this._dtABS.Rows)
					{
						if ((bool)drABS[ARTIFICIAL.ISSave] == true ||
							clearAll == true)
						{
							if (drABS.IsNull(ARTIFICIAL.IS) == false)
							{
								drABS[ARTIFICIAL.IS] = string.Empty;
								if (clearAll == true)
								{
									drABS[ARTIFICIAL.ISGuid] = DBNull.Value;
									drABS[ARTIFICIAL.ISRowVersion] = DBNull.Value;
									drABS[ARTIFICIAL.ISSave] = true;
								}
							}
						}

						if ((bool)drABS[ARTIFICIAL.C37Save] == true ||
							clearAll == true)
						{
							if (drABS.IsNull(ARTIFICIAL.C37) == false)
							{
								drABS[ARTIFICIAL.C37] = string.Empty;
								if (clearAll == true)
								{
									drABS[ARTIFICIAL.C37Guid] = DBNull.Value;
									drABS[ARTIFICIAL.C37RowVersion] = DBNull.Value;
									drABS[ARTIFICIAL.C37Save] = true;
								}
							}
						}

						if ((bool)drABS[ARTIFICIAL.AHGSave] == true ||
							clearAll == true)
						{
							if (drABS.IsNull(ARTIFICIAL.AHG) == false)
							{
								drABS[ARTIFICIAL.AHG] = string.Empty;
								if (clearAll == true)
								{
									drABS[ARTIFICIAL.AHGGuid] = DBNull.Value;
									drABS[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
									drABS[ARTIFICIAL.AHGSave] = true;
								}
							}
						}

						if ((bool)drABS[ARTIFICIAL.CCSave] == true ||
							clearAll == true)
						{
							if (drABS.IsNull(ARTIFICIAL.CC) == false)
							{
								drABS[ARTIFICIAL.CC] = string.Empty;
								if (clearAll == true)
								{
									drABS[ARTIFICIAL.CCGuid] = DBNull.Value;
									drABS[ARTIFICIAL.CCRowVersion] = DBNull.Value;
									drABS[ARTIFICIAL.CCSave] = true;
								}
							}
						}

						if ((bool)_dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] == true ||
							clearAll == true)
						{
							_dtABS.Rows[0][ARTIFICIAL.ABSInterp] = string.Empty;
							if (clearAll == true)
							{
								_dtABS.Rows[0][ARTIFICIAL.ABSInterpGuid] = DBNull.Value;
								_dtABS.Rows[0][ARTIFICIAL.ABSInterpRowVersion] = DBNull.Value;
								_dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] = true;
							}
						}

						if (_dtABS.Rows[0].IsNull(ARTIFICIAL.ABSComment) == false)
						{
							_dtABS.Rows[0][ARTIFICIAL.ABSComment] = string.Empty;
						}
					}
				}
				else //Transfusion-Only
				{
					foreach(DataRow drABS in this._dtABS.Rows)
					{
						if ((bool)drABS[ARTIFICIAL.ABSInterpSave] == true ||
							clearAll == true)
						{
							drABS[ARTIFICIAL.ABSInterp] = string.Empty;
							if (clearAll == true)
							{
								drABS[ARTIFICIAL.ABSInterpGuid] = DBNull.Value;
								drABS[ARTIFICIAL.ABSInterpRowVersion] = DBNull.Value;
								drABS[ARTIFICIAL.ABSInterpSave] = true;
							}
						}
						if (drABS.IsNull(ARTIFICIAL.ABSComment) == false)
						{
							drABS[ARTIFICIAL.ABSComment] = string.Empty;
						}
					}
				}

				this.cmbBoxComment.Text = string.Empty;

				for (int i=0; i<this._dtABS.Rows.Count; i++)
				{
					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						UpdateSolidGelIndicator();
					}
					else
					{
						UpdateTubeIndicator();
					}
				}

				SetValidEntries(this.dgABS.CurrentCell.ColumnNumber);
				this.dgABS.SetCurrentCell(0, 1);
			}
		}

		/// <summary>
		/// Check if grid is empty (contains no test results)
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			DataTable dt = ((DataView)this.dgABS.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				foreach(DataRow dr in this._dtABS.Rows)
				{
					if (dr[ARTIFICIAL.IS].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.C37].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.AHG].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.CC].ToString().Trim() != string.Empty)
						return false;
					if (dr.IsNull(ARTIFICIAL.ABSInterp) == false)
					{
						if (dr[ARTIFICIAL.ABSInterp].ToString().Trim() != string.Empty)
							return false;
					}
					if (dr.IsNull(ARTIFICIAL.ABSComment) == false)
					{
						if (dr[ARTIFICIAL.ABSComment].ToString().Trim() != string.Empty)
							return false;
					}
				}
			}
			else
			{
				if (this._dtABS.Rows[0][ARTIFICIAL.ABSInterp].ToString().Trim() != string.Empty)
					return false;
				else
					return true;
			}

			return true;
		}

		/// <summary>
		/// Enables or disables the grid
		/// CR 2805
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgABS.Enabled = status;
		}

		/// <summary>
		/// Check if there are any results from previous testing
		/// </summary>
		/// <returns></returns>
		private bool IsGridPartiallyCompleted()
		{
			foreach(DataRow dr in this._dtABS.Rows)
			{
				if ((bool)dr[ARTIFICIAL.ISSave] == false && dr.IsNull(ARTIFICIAL.IS) == false)
					return true;
				if ((bool)dr[ARTIFICIAL.C37Save] == false && dr.IsNull(ARTIFICIAL.C37) == false)
					return true;
				if ((bool)dr[ARTIFICIAL.AHGSave] == false && dr.IsNull(ARTIFICIAL.AHG) == false)
					return true;
				if ((bool)dr[ARTIFICIAL.CCSave] == false && dr.IsNull(ARTIFICIAL.CC) == false)
					return true;
				if ((bool)dr[ARTIFICIAL.ABSInterpSave] == false)
					return true;
			}

			return false;
		}

		/// <summary>
		/// Copy the comment entered in combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxComment_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				this._dtABS.Rows[0][ARTIFICIAL.ABSComment] = this.cmbBoxComment.Text;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void _dcTextKeyTrapCol_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			try
			{
				if (e.Button == MouseButtons.Right)
				{
					if (this._dtABS.Rows.Count > 0)
					{
						this.ContextMenu.Show(this, new Point(e.X, e.Y));
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion

		#region Properties

		/// <summary>
		/// Set the OrderedTest object associated with this test
		/// </summary>
		public BOL.OrderedTest OrderedTest
		{
			set
			{
				this._orderedTest = value;
			}
			get
			{
				return this._orderedTest;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Gets/sets the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new BOL.Division(value);
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Gets the valid entries for the legend
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Sets/Gets testing method used for ABS
		/// </summary>
		public Common.ReactivityPhase ReactivityPhase
		{
			get
			{
				return this._reactivityPhase;
			}
			set
			{
				this._reactivityPhase = value;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Check if data on the grid is ready to be saved to the database
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			DataTable dt = ((DataView)this.dgABS.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == "E")
						return false;
				}

				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.IS].ToString() != string.Empty ||
						dt.Rows[i][ARTIFICIAL.C37].ToString() != string.Empty ||
						dt.Rows[i][ARTIFICIAL.AHG].ToString() != string.Empty ||
						dt.Rows[i][ARTIFICIAL.CC].ToString() != string.Empty ||
						dt.Rows[i][ARTIFICIAL.ABSInterp].ToString() != string.Empty)
						return true;
				}
			}
			else //Transfusion-Only
			{
				if (dt.Rows[0][ARTIFICIAL.Indicator].ToString() != string.Empty &&
					dt.Rows[0][ARTIFICIAL.Indicator].ToString() != "E")
					return true;
			}

			return false;
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		/// <summary>
		/// Data source for grid
		/// </summary>
		public DataTable GridDataSource
		{
			get
			{
				return this._dtABS;
			}

			set
			{
				this._dtABS = value;
				if (this._dtABS.Rows.Count == 0)
				{
					this.dgABS.DataSource = this._dtABS.DefaultView;
					this.dgABS.ColumnHeadersVisible = false;
					this.btnClear.Enabled = false;
					enableInvalidation = false;
				}
				else
				{
					this.dgABS.DataSource = this._dtABS.DefaultView;
					((DataView)dgABS.DataSource).AllowNew = false;
					((DataView)dgABS.DataSource).AllowDelete = false;
					this.dgABS.ColumnHeadersVisible = true;
					this.btnClear.Enabled = true;
					enableInvalidation = true;
					this.cmbBoxComment.SelectedIndex = -1;

					if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
					{
						for (int i=0; i<this._dtABS.Rows.Count; i++)
						{
							UpdateSolidGelIndicator();
						}
					}
					else
					{
						for (int i=0; i<this._dtABS.Rows.Count; i++)
						{
							UpdateTubeIndicator();
						}
					}
				}
			}
		}

	}

	#endregion

}